#pragma once
#include "MySprite.h"
#include "Mario.h"

//Moveables inherits MySprite.  A moveable is an item which moves in the game but is NOT an enemy to Mario i.e. a PowerUp or OneUp
//This is different from a GameItem as all GameItems are static (they do not move) so a new type of MySprite makes sense

class Moveables :
	public MySprite
{
public:
	static Moveables* currentMoveable;	//static pointer to a Moveables currentMoveable

	Moveables();
	~Moveables();

	virtual void update(float dt);
	virtual void handleCollision(MySprite* sprite, float dt);

protected:
	Animation* currentAnimation;	//The animation of the moveable
	sf::Texture moveableTexture;	//The texture of the moveable
};

